﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public abstract class BaseComponent : Gemini.Core.WebApplication.Base.WebPageComponent
    {
        public BaseComponent(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam) : base(WebPageComponentParam) { }

        private BL.ZSBELearning _blELearning = null;
        public BL.ZSBELearning BLELearning
        {
            get
            {
                if (_blELearning == null)
                {
                    _blELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blELearning;
            }

        }
        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;
        public PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }
                return _blVariableRepository;
            }
        }
        public override long ClientID
        {
            get { return BLELearning.ClientID; }
        }

        public override bool IsValid
        {
            get { return true; }
        }

        public override bool IsParamKey(long ParamKey)
        {
            return false;
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            return null;
        }

        public void AppendToXML(List<BL.BO.Class> ClassList)
        {
            XML.Element.Start("ClassList");
            foreach (BL.BO.Class _loopClass in ClassList)
            {
                AppendToXML(_loopClass);
            }
            XML.Element.End();
        }

        public void AppendToXML(BL.BO.Class Class)
        {
            AppendToXML(Class, null);
        }

        public void AppendToXML(BL.BO.Class Class, Func<Gemini.Core.WebApplication.Base.GXML, BL.BO.Class, bool> XMLFunction)
        {
            if (Class != null)
            {
                XML.Element.Start("Class");
                XML.Element.Attribute("ID", Class.ID);
                XML.Element.Attribute("InstructorID", Class.InstructorID);
                XML.Element.Attribute("Name", Class.Name);
                XML.Element.Attribute("SchoolID", Class.SchoolID);
                XML.Element.Attribute("SchoolYearID", Class.SchoolYearID);
                if (Class.SchoolYearID.HasValue)
                {
                    XML.Element.Attribute("SchoolYear", BLELearning.SchoolYear.Cache.RestoreName(Class));
                }
                if (XMLFunction != null)
                {
                    XMLFunction(XML, Class);
                }
                XML.Element.End();
            }
        }

        public void AppendToXML(BL.BO.Instructor Instructor)
        {
            if (Instructor != null)
            {
                XML.Element.Start("Instructor");
                XML.Element.Attribute("Email", Instructor.Email);
                XML.Element.Attribute("Forename", Instructor.Forename);
                XML.Element.Attribute("ID", Instructor.ID);
                XML.Element.Attribute("SchoolID", Instructor.SchoolID);
                XML.Element.Attribute("Surename", Instructor.Surename);
                XML.Element.Attribute("Tel", Instructor.Tel);
                XML.Element.Attribute("Title", Instructor.Title);
                XML.Element.Attribute("UserBID", Instructor.UserID);
                XML.Element.End();
            }
        }

        public void AppendToXML(BL.BO.Student Student)
        {
            AppendToXML(Student, null);
        }

        public void AppendToXML(BL.BO.Student Student, Func<Gemini.Core.WebApplication.Base.GXML, BL.BO.Student, bool> XMLFunction)
        {
            if (Student != null)
            {
                XML.Element.Start("Student");

                XML.Element.Attribute("ClassID", Student.ClassID);
                XML.Element.Attribute("Email", Student.Email);
                XML.Element.Attribute("Forename", Student.Forename);
                XML.Element.Attribute("ID", Student.ID);
                XML.Element.Attribute("IndexNr", Student.IndexNr);
                XML.Element.Attribute("Sex", Student.Sex);
                XML.Element.Attribute("Surename", Student.Surename);
                XML.Element.Attribute("UserBID", Student.UserID);
                XML.Element.Attribute("CompetenceEvaluationSheetID", Student.CompetenceEvaluationSheetID);
                if (XMLFunction != null)
                {
                    XMLFunction(XML, Student);
                }
                XML.Element.End();
            }
        }

        public void AppendToXML(BL.BO.School School)
        {
            if (School != null)
            {
                XML.Element.Start("School");
                XML.Element.Attribute("AddressLine1", School.AddressLine1);
                XML.Element.Attribute("AddressLine2", School.AddressLine2);
                XML.Element.Attribute("Email", School.Email);
                XML.Element.Attribute("Fax", School.Fax);
                XML.Element.Attribute("ID", School.ID);
                XML.Element.Attribute("Name", School.Name);
                XML.Element.Attribute("PostCode", School.PostCode);
                XML.Element.Attribute("Tel", School.Tel);
                XML.Element.Attribute("Town", School.Town);
                XML.Element.End();
            }
        }

        public void AppendToXML(List<BL.BO.StudentDoc> StudentDocList)
        {
            XML.Element.Start("StudentDocList");
            foreach (BL.BO.StudentDoc _loopStudentDoc in StudentDocList)
            {
                AppendToXML(_loopStudentDoc);
            }
            XML.Element.End();
        }

        public void AppendToXML(BL.BO.StudentDoc StudentDoc)
        {
            XML.Element.Start("StudentDoc");
            XML.Element.Attribute("ID", StudentDoc.ID);
            XML.Element.Attribute("Name", StudentDoc.Name);
            XML.Element.Attribute("Path", StudentDoc.Path);
            XML.Element.Attribute("StudentID", StudentDoc.StudentID);
            XML.Element.End();
        }

        public void AppendGroupToXML()
        {
            PI.FM.N001.Account.BL.BO.Group _group = BLELearning.RBL.Account.Group.Restore(Environment.User.GroupID);
            XML.Element.Start("Group");
            XML.Element.Attribute("ID", _group.ID);
            XML.Element.Attribute("ClientID", _group.ClientID);
            XML.Element.Attribute("EnumID", _group.EnumID);
            XML.Element.Attribute("IsProtected", _group.IsProtected);
            XML.Element.Attribute("IsRemovable", _group.IsRemovable);
            XML.Element.Attribute("IsWebApplication", _group.IsWebApplication);
            XML.Element.Attribute("IsWinForms", _group.IsWinForms);
            XML.Element.Attribute("IsWinFormsOnly", _group.IsWinFormsOnly);
            XML.Element.Attribute("Name", _group.Name);
            XML.Element.Attribute("IsTeacher", _group.EnumID == (int)BL.Dictionary.GroupType.Instructor);
            XML.Element.Attribute("IsStudent", _group.EnumID == (int)BL.Dictionary.GroupType.Student);
            XML.Element.Attribute("IsInstruktor", _group.EnumID == (int)BL.Dictionary.GroupType.Supervisor);
            XML.Element.End();
        }

        public void AppendUserToXML(bool IsStudent)
        {
            XML.Element.Start("User");
            XML.Element.Attribute("ID", Environment.User.ID);
            XML.Element.Attribute("DisplayName", Environment.User.DisplayName);
            XML.Element.Attribute("DisplayNickname", Environment.User.DisplayNickname);
            XML.Element.Attribute("GroupID", Environment.User.GroupID);
            XML.Element.Attribute("IsStudent", IsStudent);
            XML.Element.End();
        }
    }
}